Option Strict Off
Option Explicit On
Module Module1
	'// 1.  Find ROCKEY2 dongles attached to the computer
	Declare Function RY2_Find Lib "ROCKEY2.DLL" () As Integer
	'// return value
	'// <0	Error code
	'// =0	No ROCKEY2 dongle is attached
	'// >0	The number of attached ROCKEY2 dongle(s) 
	'// ====================================================================
	'
	'// 2. Open specified ROCKEY2 dongle
	
	Declare Function RY2_Open Lib "ROCKEY2.DLL" (ByVal mode As Integer, ByVal uid As Integer, ByRef hid As Integer) As Integer
	
	'// input:
	'// mode----This parameter indicates the way to open the dongle
	'// mode = 0, open the first found ROCKEY2 dongle
	'// mode > 0, open the dongle according to the UID. The mode value is the dongle number, 
	'//           for example: uid=12345678, mode=2, this means it will open the second dongle with UID 12345678
	'// mode = -1, open the dongle according to the HID, and *hid can not be 0
	'//We defined two MACROs: 
	Public Const AUTO_MODE As Short = 0
	
	Public Const HID_MODE As Short = -1
	
	'// uid---UserID,You need to specify the dongle UID and this UID is generated with RY2_GenUID
	'// hid---Hardware ID,Open dongle with HID of *hid
	'// The dongle HID will be returned to *hid regardless of how the dongle was opened.
	'// return vaule:
	'// >=0	Success. The opened dongle handle is returned.
	'// < 0	Error code. Please refer to the later
	
	'// ====================================================================
	'
	'// 3. Close specified ROCKEY2 dongle
	Declare Sub RY2_Close Lib "ROCKEY2.DLL" (ByVal handle As Integer)
	'// Input:
	'// handle---ROCKEY2 dongle handle. It is the handle returned from RY2_Open 
	'// Return:
	'// N/A

    '// ====================================================================
    '
    '// 4.Generate User ID(UID)

    Declare Function RY2_GenUID Lib "ROCKEY2.DLL" (ByVal handle As Integer, ByRef uid As Integer, ByVal seed As String, ByVal isProtect As Integer) As Integer
		'// input:
		'// handle---Dongle handle. It is the handle returned from RY2_Open.
		'// uid---Output parameter. The generated UID.
		'// seed---Seed to generate UID. It is a character string with the maximum length of 64 bytes
    '// isProtect is the ROCKEY2 is write protected
    Public Const ROCKEY2_DISABLE_WRITE_PROTECT As Short = 0
    Public Const ROCKEY2_ENSABLE_WRITE_PROTECT As Short = 1
		'// Return:
		'// Error code. Please refer to the error codes
    '
    '// ====================================================================

    '// 5. Read dongle content


    Declare Function RY2_Read Lib "ROCKEY2.DLL" (ByVal handle As Integer, ByVal block_index As Short, ByVal buffer512 As String) As Integer
		'// input:
		'// handle---Dongle handle. It is the handle returned from RY2_Open.
		'// block_index---Block index. Specify the block to read. The value range is 0-4.
		'// buffer512---Read buffer. The buffer must be at least 512 bytes to accommodate the 512 byte block size.
		'// Return:
		'// Error code. Please refer to the later

    '// ====================================================================
    '
    '// 6. Write to ROCKEY2 dongle


    Declare Function RY2_Write Lib "ROCKEY2.DLL" (ByVal handle As Integer, ByVal block_index As Short, ByVal buffer512 As String ) As Integer
	
		'// input:
		'// handle---Dongle handle. It is the handle returned from RY2_Open 
		'// block_index---Block index. Specify the block to read. The value range is 0-4.
		'// buffer512---Read buffer. The buffer must be at least 512 bytes to accommodate the 512 byte block size.
		'// Return:
		'// Error code. Please refer to the later
		
		
		'// Error code ===========================================================
	'
	'// Success
	Public Const RY2ERR_SUCCESS As Short = 0
	'
	'// Specified dongle is not found (parameter error)
	Public Const RY2ERR_NO_SUCH_DEVICE As Integer = &HA0100001
	'
	'// Need to call RY2_Open first to open the dongle, then call this function (operation error)
	Public Const RY2ERR_NOT_OPENED_DEVICE As Integer = &HA0100002
	'
	'// Wrong UID(parameter error)
	Public Const RY2ERR_WRONG_UID As Integer = &HA0100003
	'
	'// Block index error (parameter error)
	Public Const RY2ERR_WRONG_INDEX As Integer = &HA0100004
	'
	'// Seed character string is longer than 64 bytes when calling GenUID (parameter error)
	Public Const RY2ERR_TOO_LONG_SEED As Integer = &HA0100005
	'
	'// Tried to write to write-protected dongle(operation error)
	Public Const RY2ERR_WRITE_PROTECT As Integer = &HA0100006
	'
	'// Open device error (Windows error)
	Public Const RY2ERR_OPEN_DEVICE As Integer = &HA0100007
	'
	'// Read record error(Windows error)
	Public Const RY2ERR_READ_REPORT As Integer = &HA0100008
	'
	'// Write record error(Windows error)
	Public Const RY2ERR_WRITE_REPORT As Integer = &HA0100009
	'
	'// Internal error (Windows error)
	Public Const RY2ERR_SETUP_DI_GET_DEVICE_INTERFACE_DETAIL As Integer = &HA010000A
	'
	'// Internal error (Windows error)
	Public Const RY2ERR_GET_ATTRIBUTES As Integer = &HA010000B
	'
	'// Internal error (Windows error)
	Public Const RY2ERR_GET_PREPARSED_DATA As Integer = &HA010000C
	'
	'// Internal error (Windows error)
	Public Const RY2ERR_GETCAPS As Integer = &HA010000D
	'
	'// Internal error (Windows error)
	Public Const RY2ERR_FREE_PREPARSED_DATA As Integer = &HA010000E
	'
	'// Internal error (Windows error)
	Public Const RY2ERR_FLUSH_QUEUE As Integer = &HA010000F
	'
	'// Internal error (Windows error)
	Public Const RY2ERR_SETUP_DI_CLASS_DEVS As Integer = &HA0100010
	'
	'// Internal error (Windows error)
	Public Const RY2ERR_GET_SERIAL As Integer = &HA0100011
	'
	'// Internal error (Windows error)
	Public Const RY2ERR_GET_PRODUCT_STRING As Integer = &HA0100012
	'
	'// Internal error
	Public Const RY2ERR_TOO_LONG_DEVICE_DETAIL As Integer = &HA0100013
	'
	'// Unknown device(hardware error)
	Public Const RY2ERR_UNKNOWN_DEVICE As Integer = &HA0100020
	'
	'// Verification error(hardware error)
	Public Const RY2ERR_VERIFY As Integer = &HA0100021
	'
	'// Unknown error(hardware error)
	Public Const RY2ERR_UNKNOWN_ERROR As Integer = &HA010FFFF
	'
End Module